﻿var editPanelAttribute = {
    context: $(".v-editPanelAttribute"),
    bindEvents: function () {
        editPanelAttribute.context.on("change", ".h-typeSelector", function () {
            $(".v-picklistFields", editPanelAttribute.context).toggle($(this).val() == "Picklist");
        });

        $(".v-pickListTableEditor", editPanelAttribute.context).each(function () {
            var editor = $(this);

            editor.on("click", ".h-deleteRow", function () {
                var item = $(this).closest(".v-editableItem");               
                editPanelAttribute.replaceItemIndexes(item);

                item.remove();
                editPanelAttribute.updateFieldIndexes(0);

                if ($('.v-picklistTable tbody tr:not(.deleted)', editor).length == 0) {
                    $('.v-picklistTable', editor).hide();
                }
            });


            editor.on("click", ".h-addRow", function () {
                var rowId = $(".v-picklistTableBody tr", editor).length + 1;
                var rowPosition = $(".v-picklistTableBody tr:visible", editor).length + 1;

                $('.v-picklistTable', editor).show();

                var newItem = $(".v-newItems .v-newItemBody tr", editor).clone();
                newItem.find(".v-itemIndex").html(rowPosition);
                newItem.removeClass("row0");
                newItem.addClass("row" + rowId);                

                newItem.appendTo($("table .v-picklistTableBody", editor));
                editPanelAttribute.updateFieldIndexes(0);
                $(".row" + rowId + " input", editor).on("keypress", function (e) { return a4.disableEnter(e); });
            });

            editor.on("click", ".h-addMultipleRows", function () {
                var addButton = $(this).prev(".h-addRow");
                var editPanel = $('.v-picklistTableBody');
                var choices = $(".v-choiceListTable", editPanel).length > 0;
                var startRows = $(".v-editableItem:visible", editPanel);

                editPanelAttribute.showAddMultipleDialog(editor, startRows, choices, function (items) {
                    editPanel.addClass("addingMultipleItems");
                    editPanelAttribute.addMultipleItems(items, startRows, editPanel, addButton);
                    editPanel.removeClass("addingMultipleItems");
                });
            });
        });
    },

    addMultipleItems: function (items, startRows, editPanel, addButton) {
        var i = 0;
        var itemCounts = 0;
        var row = null;
        var empty = null;

        var addItemFn = function () {
            addButton.trigger("click");            
        };
        
        $.each(items, function (index, item) {
            empty = ((item.Value == null || item.Value == "") && item.Label == "");

            if (item && (!empty || (startRows && itemCounts <= startRows.length))) {    // newly created empty rows are disregarded
                itemCounts++;

                if (empty) {
                    startRows.eq(i++).remove();
                }
                else {
                    if (startRows && startRows.length > i) {
                        row = startRows.eq(i++);
                    }
                    else {
                        addItemFn();
                        row = $(".v-editableItem:last", editPanel);
                    }

                    var name = $(".v-itemValue", row);
                    var text = $(".v-itemLabel", row);

                    if (name.length > 0 && item.Value) {
                        name.val(a4.escapeHtml(item.Value).replace(/\W/g, ''));
                    }

                    if (item.Label && text.length > 0) {
                        text.val(a4.closeHtmlTags($.trim(item.Label)));                        
                    }
                }
            }
        });


        while (startRows && itemCounts < startRows.length) {
            startRows.eq(itemCounts++).remove();
        }

        editPanelAttribute.updateFieldIndexes(0);
    },

    showAddMultipleDialog: function (owner, startRows, choices, saveFunction, message) {
        var instruction = $('<div>' + ((message) ? message : resources.Message_AddMultipleAnswerInstruction) + '</div>');
        var h = 400;
        var w = 500;
        var textarea = $('<textarea style="height:' + h + 'px; max-height:12em; width:' + (w-100) + 'px; max-width:600px; margin-top:10px;"></textarea>');
        var label = null;

        if (startRows != null) {
            startRows.each(function (i, e) {
                var name = $(".v-itemValue", e);
                var text = $(".v-itemLabel", e);
                label = name.val() + "," + text.val();
                textarea.append(label + "\r\n");
            });
        }

        var content = $('<div id="AddMultipleDialogContainer">').append(instruction).append(textarea);

        var addMultipleResources = {
            "Title": resources.AddEditMultiple,
            "Message": content
        };

        var yesFunction = function () {
            var newRows = _.compact(_.map($('textarea', content).val().split('\n'),
                            function (label) { return editPanelAttribute.extractEditMultipleValueAndText(label); }));

            saveFunction(newRows);
        }
        
        modalDialog.showConfirmDialog(addMultipleResources, yesFunction, h, w);        
    },

    extractEditMultipleValueAndText: function (item) {
        var a = {};
        var value = null;
        var label = $.trim(item);

        var i = item.indexOf(",");

        if (i != -1) {
            value = item.substring(0, i);
            label = item.substring(i + 1);
        }
        else {
            value = label;
            label = "";
        }        

        a.Value = value;
        a.Label = label;
        return a;
    },

    updateFieldIndexes: function(rowId) {
        $(".v-picklistTableBody tr", editPanelAttribute.context).each(function () {
            $(this).find(".v-itemValue").attr("name", "PicklistFields[" + (rowId) + "].Value");
            $(this).find(".v-itemLabel").attr("name", "PicklistFields[" + (rowId) + "].Label");
            rowId++;
        });
    },

    replaceItemIndexes: function (startItem, increaseStartItem) {
        // Replace order if item deleted
        var previousIndex = $(".v-itemIndex", startItem).html();

        // For cancel of delete
        if (increaseStartItem) {
            previousIndex++;
        }

        startItem.nextAll(".v-editableItem:visible").each(function () {
            $(".v-itemIndex", $(this)).html(previousIndex);
            $(".v-rowPosition", $(this)).val(previousIndex);
            previousIndex++;
        });
    }
}

$(document).ready(function () {
    if (editPanelAttribute.context.length > 0) {
        editPanelAttribute.bindEvents();
    }
});